import refreshTokenHelper from "../../../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../../../utils/errorHandlingHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const config = useRuntimeConfig()
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  if(body.docTypeId && body.refListId) {
    const res: any = await event.context.fetch('models/ad_document_action_access', 'POST', token, {
      AD_Org_ID: {
        id: body.organizationId,
        tableName: 'AD_Org'
      },
      AD_Role_ID: {
        id: body.roleId,
        tableName: 'AD_Role'
      },
      C_DocType_ID: {
        id: body.docTypeId,
        tableName: 'C_DocType'
      },
      AD_Ref_List_ID: {
        id: body.refListId,
        tableName: 'AD_Ref_List'
      },
      isActive: body.isActive,
      tableName: 'AD_Document_Action_Access'
    })
    if(res) {
      data = res
      data['status'] = 200
      data['message'] = ''
    }
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})